<?php

namespace Avodel\WebBot\Context;

final class OptionsBuilder
{
    private ?int $timeLimitSec = null;
    private int $sleepBetweenActionsMinSec = 0;
    private int $sleepBetweenActionsMaxSec = 0;
    private array $upstreamProxyServers = [];
    private ?int $rotateUpstreamProxyServerIntervalSec = null;
    private ?string $tag = null;
    private ?Schedule $schedule = null;
    private bool $actualUserAgent = false;

    public function timeLimitSec(int $timeLimitSec): self
    {
        $this->timeLimitSec = $timeLimitSec;

        return $this;
    }

    public function sleepBetweenActionsMinSec(int $sleepBetweenActionsMinSec): self
    {
        $this->sleepBetweenActionsMinSec = $sleepBetweenActionsMinSec;

        return $this;
    }

    public function sleepBetweenActionsMaxSec(int $sleepBetweenActionsMaxSec): self
    {
        $this->sleepBetweenActionsMaxSec = $sleepBetweenActionsMaxSec;

        return $this;
    }

    public function upstreamProxyServers(array $upstreamProxyServers): self
    {
        $this->upstreamProxyServers = $upstreamProxyServers;

        return $this;
    }

    public function rotateUpstreamProxyServerIntervalSec(int $rotateUpstreamProxyServerIntervalSec): self
    {
        $this->rotateUpstreamProxyServerIntervalSec = $rotateUpstreamProxyServerIntervalSec;

        return $this;
    }

    public function schedule(Schedule $schedule): self
    {
        $this->schedule = $schedule;

        return $this;
    }

    public function tag(string $tag): self
    {
        $this->tag = $tag;

        return $this;
    }

    public function actualUserAgent(bool $actualUserAgent): self
    {
        $this->actualUserAgent = $actualUserAgent;

        return $this;
    }

    public function build(): Options
    {
        return new Options(
            $this->schedule,
            $this->timeLimitSec,
            $this->sleepBetweenActionsMinSec,
            $this->sleepBetweenActionsMaxSec,
            $this->upstreamProxyServers,
            $this->rotateUpstreamProxyServerIntervalSec,
            $this->tag,
            $this->actualUserAgent
        );
    }
}
