<?php

namespace Avodel\WebBot\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('avodel_web_bot');

        // @phpstan-ignore-next-line
        $treeBuilder->getRootNode()
            ->children()
                ->arrayNode('profile')
                    ->useAttributeAsKey('name')
                        ->arrayPrototype()
                        ->children()
                            ->arrayNode('actions')
                                ->scalarPrototype()->end()
                            ->end()
                            ->arrayNode('exception_handlers')
                                ->scalarPrototype()->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end();

        return $treeBuilder;
    }
}
