<?php

namespace Avodel\WebBot\Proxy;

use Avodel\ProxyHandler\ProxyHandlerInterface;
use DateTimeImmutable;
use Psr\Clock\ClockInterface;
use Psr\Log\LoggerInterface;

final class ProxyManager
{
    private ?DateTimeImmutable $upstreamConnectedAt = null;

    private ?int $currentIndex = null;

    public function __construct(
        private readonly ProxyHandlerInterface $proxyHandler,
        private readonly array $upstreamProxyServers,
        private readonly ClockInterface $clock,
        private readonly LoggerInterface $logger,
    )
    {
    }

    public function rotateUpstreamProxy(): void
    {
        $nextIndex = 0;

        if ($this->currentIndex !== null && $this->currentIndex !== array_key_last($this->upstreamProxyServers)) {
            $nextIndex = $this->currentIndex + 1;
        }

        $this->currentIndex = $nextIndex;
        $dsn = $this->upstreamProxyServers[$nextIndex];

        $this->proxyHandler->upstream($dsn);
        $this->logger->info('Rotating upstream proxy.', ['index' => $nextIndex]);

        $this->upstreamConnectedAt = $this->clock->now();
    }

    public function getUpstreamConnectedAt(): ?DateTimeImmutable
    {
        return $this->upstreamConnectedAt;
    }
}
