# Web Bot
The web bot implementation provides a foundation for automating web interactions.
It controls the sequential execution of actions on a webpage and, when needed, attempts to handle errors through special handlers to allow the bot to continue running.

# Workflow
## Action
An [ActionInterface](src/Worker/ActionInterface.php) defines a specific task the web bot performs on a webpage. Examples of actions include clicking elements, submitting forms, or filling in fields. Each Action checks if it is applicable to the current state of the webpage (via the isApplicable method) and, if applicable, performs the task (using the perform method).

## Exception Handler
An [ExceptionHandlerInterface](src/Worker/ExceptionHandlerInterface.php) defines how to manage errors that occur during the web bot’s execution. When an action fails and throws an exception, the [ExceptionHandlerInterface](src/Worker/ExceptionHandlerInterface.php) determines if it can handle the error (via the handleException method). If the handler successfully processes the exception, it allows the bot to continue running. Otherwise, if no handler resolves the error, the bot’s execution may stop.

## Context
The [Context](src/Context/Context.php) object is available throughout the entire run of the web bot and is responsible for storing and managing the state of the run.

# Configuration
The profile section in the configuration allows you to define different combinations of actions and exception handlers for the web bot. Each profile can be customized with specific actions the bot will perform and exception handlers to manage any errors encountered during execution. This setup enables flexibility, allowing you to create multiple profiles for different use cases or environments, each with its own tailored sequence of actions and error-handling strategies.

```yaml
avodel_web_bot:
    profile:
        default: # any profile name
            actions:
                - App\MyAction1
                - App\MyAction2
                # ...
            exception_handlers:
                - App\ExceptionHandler1
                - App\ExceptionHandler2
                # ...
```

# Execution
This command allows you to execute a specific worker profile with customizable options.

```shell
php bin/console webbot:run <profile> <options>
```

### Options
* --time-limit: Limits the worker’s runtime.
* --pause-between-user-actions: Pauses between user actions (clicks, text input, dropdown selects) for a random duration.
* --upstream-proxy-servers: Routes traffic through specified proxy servers.
* --shuffle-upstream-proxy-servers: Randomizes upstream proxy servers.
* --actual-user-agent: Updates the user agent to the latest version.
* --tag: Adds a tag for logging purposes.
* --schedule: Defines the worker’s active schedule, such as days and times of operation.

# Out-of-the-box features
1. Automatic captcha verification
2. Waiting for all AJAX requests to finish
3. Run according to schedule
4. Setting time limit
5. Actualize user agent on the fly
6. Perform pause between actions
7. Automatic dumping of screenshots and page content on error
8. Automatic IP changing on gRECaptchav3 blocks
9. Automatic change of IP address at certain intervals
