<?php

namespace Avodel\WebBot\Extension\Captcha;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ExceptionHandlerInterface;
use Avodel\WebDriver\WebDriver;
use Throwable;

final readonly class GoogleRecaptchaV3VerificationExceptionHandler implements ExceptionHandlerInterface
{
    public function handleException(WebDriver $webDriver, Context $context, Throwable $exception): bool
    {
        if (!$exception instanceof GoogleRecaptchaV3VerificationException) {
            return false;
        }

        $proxyManager = $context->getProxyManager();

        if (!$proxyManager) {
            return false;
        }

        $proxyManager->rotateUpstreamProxy();

        return true;
    }
}
