<?php

namespace Avodel\WebBot\Context;

final class OptionsBuilder
{
    private ?int $timeLimitSec = null;
    private int $pauseBetweenUserActionsMinSec = 0;
    private int $pauseBetweenUserActionsMaxSec = 0;
    private array $upstreamProxyServers = [];
    private ?int $rotateUpstreamProxyServerIntervalSec = null;
    private ?string $tag = null;
    private ?Schedule $schedule = null;
    private bool $actualUserAgent = false;

    public function timeLimitSec(int $timeLimitSec): self
    {
        $this->timeLimitSec = $timeLimitSec;

        return $this;
    }

    public function pauseBetweenUserActionsMinSec(int $pauseBetweenUserActions): self
    {
        $this->pauseBetweenUserActionsMinSec = $pauseBetweenUserActions;

        return $this;
    }

    public function pauseBetweenUserActionsMaxSec(int $pauseBetweenUserActionsMaxSec): self
    {
        $this->pauseBetweenUserActionsMaxSec = $pauseBetweenUserActionsMaxSec;

        return $this;
    }

    public function upstreamProxyServers(array $upstreamProxyServers): self
    {
        $this->upstreamProxyServers = $upstreamProxyServers;

        return $this;
    }

    public function rotateUpstreamProxyServerIntervalSec(int $rotateUpstreamProxyServerIntervalSec): self
    {
        $this->rotateUpstreamProxyServerIntervalSec = $rotateUpstreamProxyServerIntervalSec;

        return $this;
    }

    public function schedule(Schedule $schedule): self
    {
        $this->schedule = $schedule;

        return $this;
    }

    public function tag(string $tag): self
    {
        $this->tag = $tag;

        return $this;
    }

    public function actualUserAgent(bool $actualUserAgent): self
    {
        $this->actualUserAgent = $actualUserAgent;

        return $this;
    }

    public function build(): Options
    {
        return new Options(
            $this->schedule,
            $this->timeLimitSec,
            $this->pauseBetweenUserActionsMinSec,
            $this->pauseBetweenUserActionsMaxSec,
            $this->upstreamProxyServers,
            $this->rotateUpstreamProxyServerIntervalSec,
            $this->tag,
            $this->actualUserAgent
        );
    }
}
