<?php

namespace Avodel\WebBot\Worker;

final class WorkersRegistry
{
    /**
     * @var array<string, Worker>
     */
    private array $workers = [];

    public function add(string $profile, Worker $worker): void
    {
        $this->workers[$profile] = $worker;
    }

    public function getWorker(string $profile): Worker
    {
        return $this->workers[$profile] ?? throw new \InvalidArgumentException('Worker not found.');
    }
}
