<?php

namespace Avodel\WebBot\DependencyInjection;

use Avodel\WebBot\Extension\Ajax\WaitUntilAjaxRequestsFinishedAction;
use Avodel\WebBot\Extension\Captcha\CaptchaVerifierAction;
use Avodel\WebBot\Extension\Captcha\GoogleRecaptchaV3VerificationExceptionHandler;
use Avodel\WebBot\Extension\Captcha\SetActualUserAgentAction;
use Avodel\WebBot\Extension\Fallback\FallbackAction;
use Avodel\WebBot\Extension\Fallback\FallbackExceptionHandler;
use Avodel\WebBot\Extension\Proxy\RotateUpstreamProxyAction;
use Avodel\WebBot\Extension\Schedule\RunAccordingToScheduleAction;
use Avodel\WebBot\Extension\Pause\PauseBetweenUserActionsAction;
use Avodel\WebBot\Extension\TimeLimit\StopWorkerOnTimeLimitAction;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

final class AvodelWebBotExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container): void
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yaml');

        foreach ($config['profile'] as $profile => $profileConfig) {
            $actions = [
                // default system actions
                StopWorkerOnTimeLimitAction::class,
                SetActualUserAgentAction::class,
                RunAccordingToScheduleAction::class,
                RotateUpstreamProxyAction::class,
                PauseBetweenUserActionsAction::class,
                CaptchaVerifierAction::class,
                WaitUntilAjaxRequestsFinishedAction::class,
            ];

            array_push($actions, ...$profileConfig['actions']);

            $actions[] = FallbackAction::class;

            $container->setParameter('avodel.web_bot.profile.' . $profile . '.actions', $actions);

            $exceptionHandlers = $profileConfig['exception_handlers'];
            $exceptionHandlers[] = GoogleRecaptchaV3VerificationExceptionHandler::class;
            $exceptionHandlers[] = FallbackExceptionHandler::class;

            $container->setParameter('avodel.web_bot.profile.' . $profile . '.exception_handlers', $exceptionHandlers);
        }

        $container->setParameter('avodel.web_bot.profiles', array_keys($config['profile']));
    }
}
