<?php

namespace Avodel\WebBot\Extension\Proxy;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebDriver\WebDriver;
use Psr\Clock\ClockInterface;

/**
 * The purpose of this class is to rotate upstream proxy server every X seconds.
 */
final readonly class RotateUpstreamProxyAction implements ActionInterface
{
    public function __construct(
        private ClockInterface $clock,
    )
    {
    }

    public function perform(WebDriver $webDriver, Context $context): void
    {
        $context->getProxyManager()?->rotateUpstreamProxy();
    }

    public function isApplicable(WebDriver $webDriver, Context $context): bool
    {
        $proxyManager = $context->getProxyManager();

        if (!$proxyManager) {
            return false;
        }

        $upstreamConnectedAt = $proxyManager->getUpstreamConnectedAt();

        if ($upstreamConnectedAt === null) {
            return true;
        }

        $rotateEverySec = $context->getOptions()->getRotateUpstreamProxyServerIntervalSec();

        if ($rotateEverySec === null) {
            return false;
        }

        return $this->clock->now() >= $upstreamConnectedAt->modify('+' . $rotateEverySec . ' seconds');
    }

}
