<?php

namespace Avodel\WebBot\Extension\Captcha;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebDriver\WebDriver;
use Psr\Log\LoggerInterface;

final class SetActualUserAgentAction implements ActionInterface
{
    private ?string $actualUserAgent = null;

    public function __construct(
        private readonly WebDriver $webDriver,
        private readonly LoggerInterface $logger,
    )
    {
    }

    public function perform(WebDriver $webDriver, Context $context): void
    {
        $this->actualUserAgent = $this->getActualUserAgent();

        if ($this->actualUserAgent === null) {
            $this->logger->warning('Unable to get latest user agent.');
            return;
        }

        $this->webDriver->getDevToolsDriver()->setUserAgentOverride($this->actualUserAgent);
    }

    public function isApplicable(WebDriver $webDriver, Context $context): bool
    {
        if (!$context->getOptions()->isRequireActualUserAgent()) {
            return false;
        }

        $actualUserAgent = $this->actualUserAgent ?? $this->getActualUserAgent();
        $currentUserAgent = $webDriver->evaluateScript('navigator.userAgent');

        return $actualUserAgent !== $currentUserAgent;
    }

    /**
     * @return string|null
     */
    public function getActualUserAgent(): ?string
    {
        $userAgent = file_get_contents('https://capmonster.cloud/api/useragent/actual');

        if ($userAgent === false) {
            return null;
        }

        return $userAgent;
    }
}
