<?php

namespace Avodel\WebBot\Extension\WebDriver;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebDriver\WebDriver;
use Behat\Mink\Exception\DriverException;

final readonly class StartWebDriverAction implements ActionInterface
{
    /**
     * @throws CouldNotOpenConnectionException
     * @throws DriverException
     */
    public function perform(WebDriver $webDriver, Context $context): void
    {
        try {
            $webDriver->start();
        } catch (DriverException $exception) {
            // originally the message is super long and contains, which elasticsearch can't handle
            // this catches and rethrows it with a shorter message
            if (str_starts_with('Could not open connection', $exception->getMessage())) {
                throw new CouldNotOpenConnectionException('Could not open connection. Probably the WebDriver server is not running.');
            }

            throw $exception;
        }
    }

    public function isApplicable(WebDriver $webDriver, Context $context): bool
    {
        return !$webDriver->isStarted();
    }
}
