<?php

declare(strict_types=1);

namespace Avodel\WebBot\Extension\Fallback;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebDriver\WebDriver;
use Override;
use RuntimeException;

final readonly class FallbackAction implements ActionInterface
{
    #[Override]
    public function perform(WebDriver $webDriver, Context $context): void
    {
        throw new RuntimeException('Unexpected context.');
    }

    #[Override]
    public function isApplicable(WebDriver $webDriver, Context $context): bool
    {
        return true;
    }
}
