<?php

namespace Avodel\WebBot\Extension\Captcha;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebDriver\Components\CaptchaVerifier\Exception\CaptchaVerificationFailedException;
use Avodel\WebDriver\Components\Frames\SwitchToFrameException;
use Avodel\WebDriver\WebDriver;

final readonly class WaitForCaptchaWidgetReadinessAction implements ActionInterface
{
    private const int MAX_WAITING_TIME_MS = 30_000;

    /**
     * @throws CaptchaVerificationFailedException
     * @throws SwitchToFrameException
     */
    public function perform(WebDriver $webDriver, Context $context): void
    {
        $frames = $webDriver->getFramesHandler()->getFrames();

        foreach ($frames as $frame) {
            if (str_starts_with($frame->getSrc(), 'https://www.google.com/recaptcha/api2/anchor')) {
                try {
                    $webDriver->getFramesHandler()->switchToIFrame($frame->getPath());
                    $waited = $webDriver->wait(self::MAX_WAITING_TIME_MS, 'document.querySelector(\'#rc-anchor-container\') !== null');

                    if (!$waited) {
                        throw new CaptchaVerificationFailedException('RecaptchaV2 checkbox wan not rendered.');
                    }
                } finally {
                    $webDriver->getFramesHandler()->switchToMainWindow();
                }
            }

            if (str_starts_with($frame->getSrc(), 'https://newassets.hcaptcha.com/captcha/') && str_contains($frame->getSrc(), '#frame=checkbox')) {
                try {
                    $webDriver->getFramesHandler()->switchToIFrame($frame->getPath());
                    $waited = $webDriver->wait(self::MAX_WAITING_TIME_MS, 'document.querySelector(\'#anchor\') !== null');

                    if (!$waited) {
                        throw new CaptchaVerificationFailedException('HCaptcha checkbox wan not rendered.');
                    }
                } finally {
                    $webDriver->getFramesHandler()->switchToMainWindow();
                }
            }
        }

    }

    public function isApplicable(WebDriver $webDriver, Context $context): bool
    {
        $frames = $webDriver->getFramesHandler()->getFrames();

        foreach ($frames as $frame) {
            if (str_starts_with($frame->getSrc(), 'https://www.google.com/recaptcha/api2/anchor')) {
                try {
                    $webDriver->getFramesHandler()->switchToIFrame($frame->getPath());
                    $checkbox = $webDriver->getPage()->find('css', '#rc-anchor-container');

                    if (!$checkbox) {
                        return true;
                    }
                } finally {
                    $webDriver->getFramesHandler()->switchToMainWindow();
                }
            }

            if (str_starts_with($frame->getSrc(), 'https://newassets.hcaptcha.com/captcha/') && str_contains($frame->getSrc(), '#frame=checkbox')) {
                try {
                    $webDriver->getFramesHandler()->switchToIFrame($frame->getPath());
                    $checkbox = $webDriver->getPage()->find('css', '#anchor');

                    if (!$checkbox) {
                        return true;
                    }
                } finally {
                    $webDriver->getFramesHandler()->switchToMainWindow();
                }
            }
        }

        return false;
    }
}
