<?php

namespace Avodel\WebBot\Context;

final readonly class Options
{
    public function __construct(
        private Schedule $schedule,
        private ?int $timeLimitSec = null,
        private int $pauseBetweenUserActionsMinMs = 0,
        private int $pauseBetweenUserActionsMaxMs = 0,
        private ?string $tag = null,
    )
    {
    }

    public static function builder(): OptionsBuilder
    {
        return new OptionsBuilder();
    }

    public function getTimeLimitSec(): ?int
    {
        return $this->timeLimitSec;
    }

    public function getPauseBetweenUserActionsMinMs(): int
    {
        return $this->pauseBetweenUserActionsMinMs;
    }

    public function getPauseBetweenUserActionsMaxMs(): int
    {
        return $this->pauseBetweenUserActionsMaxMs;
    }

    public function getTag(): ?string
    {
        return $this->tag;
    }

    public function getSchedule(): Schedule
    {
        return $this->schedule;
    }
}
