<?php

namespace Avodel\WebBot\Context;

final class OptionsBuilder
{
    private ?int $timeLimitSec = null;
    private int $pauseBetweenUserActionsMinMs = 0;
    private int $pauseBetweenUserActionsMaxMs = 0;
    private ?string $tag = null;
    private ?Schedule $schedule = null;

    public function timeLimitSec(int $timeLimitSec): self
    {
        $this->timeLimitSec = $timeLimitSec;

        return $this;
    }

    public function pauseBetweenUserActionsMinMs(int $pauseBetweenUserActionsMinMs): self
    {
        $this->pauseBetweenUserActionsMinMs = $pauseBetweenUserActionsMinMs;

        return $this;
    }

    public function pauseBetweenUserActionsMaxMs(int $pauseBetweenUserActionsMaxMs): self
    {
        $this->pauseBetweenUserActionsMaxMs = $pauseBetweenUserActionsMaxMs;

        return $this;
    }

    public function schedule(Schedule $schedule): self
    {
        $this->schedule = $schedule;

        return $this;
    }

    public function tag(string $tag): self
    {
        $this->tag = $tag;

        return $this;
    }

    public function build(): Options
    {
        return new Options(
            $this->schedule,
            $this->timeLimitSec,
            $this->pauseBetweenUserActionsMinMs,
            $this->pauseBetweenUserActionsMaxMs,
            $this->tag,
        );
    }
}
