<?php

namespace Avodel\WebBot\Extension\Schedule;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebDriver\Driver\WebDriver;
use Psr\Clock\ClockInterface;
use Psr\Log\LoggerInterface;

final readonly class RunAccordingToScheduleAction implements ActionInterface
{
    public function __construct(
        private LoggerInterface $logger,
        private ClockInterface $clock,
        private ?IdleHandlerInterface $idleHandler = null,
    )
    {
    }

    public function perform(WebDriver $webDriver, Context $context): void
    {
        $this->logger->info('Idle due to schedule.');
        $this->idleHandler?->handle($context);
        sleep(60);
    }

    public function isApplicable(WebDriver $webDriver, Context $context): bool
    {
        return !$context->getOptions()->getSchedule()->isNowWithinSchedule($this->clock->now());
    }
}
