<?php

declare(strict_types=1);

namespace Avodel\WebBot\Logger;

use Avodel\WebBot\Context\ContextHolder;
use Monolog\LogRecord;
use Monolog\Processor\ProcessorInterface;

final readonly class WebBotLoggerProcessor implements ProcessorInterface
{
    public function __construct(
        private ContextHolder $contextHolder,
    )
    {
    }

    public function __invoke(LogRecord $record)
    {
        $context = $this->contextHolder->getContext();
        $record->extra['webbot_run_id'] = $context?->getRunId();
        $record->extra['webbot_tag'] = $context?->getOptions()->getTag();

        return $record;
    }
}
