<?php

declare(strict_types=1);

namespace Avodel\WebBot\Extension\WebDriver;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ExceptionHandlerInterface;
use Avodel\WebDriver\Driver\WebDriver;
use Override;
use Psr\Log\LoggerInterface;
use Throwable;

final readonly class FallbackExceptionHandler implements ExceptionHandlerInterface
{
    public function __construct(
        private LoggerInterface $logger,
    )
    {
    }

    #[Override]
    public function handleException(WebDriver $webDriver, Context $context, Throwable $exception): bool
    {
        $this->logger->error($exception->getMessage(), [
            'exception' => $exception,
            'debug' => $webDriver->getDebugger()->dump(),
        ]);

        return false;
    }
}
