<?php

declare(strict_types=1);

namespace Avodel\WebBot\Extension\Network;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebDriver\Driver\WebDriver;

final readonly class ClientClosedRequestAction implements ActionInterface
{
    /**
     * @throws NetworkErrorException
     */
    public function perform(WebDriver $webDriver, Context $context): never
    {
        throw new NetworkErrorException('Client Closed Request', '', '499');
    }

    public function isApplicable(WebDriver $webDriver, Context $context): bool
    {
        return str_contains((string) $webDriver->getPage()->getHtml(), '<title>499 Client Closed Request</title>');
    }
}
