<?php

declare(strict_types=1);

namespace Avodel\WebBot\Extension\Captcha;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ExceptionHandlerInterface;
use Avodel\WebDriver\Components\CaptchaVerifier\Exception\CaptchaVerificationFailedException;
use Avodel\WebDriver\Components\CaptchaVerifier\Exception\CheckboxFrameNotFoundException;
use Avodel\WebDriver\Driver\WebDriver;
use Facebook\WebDriver\Exception\ElementClickInterceptedException;
use Facebook\WebDriver\Exception\ElementNotInteractableException;
use Facebook\WebDriver\Exception\NoSuchFrameException;
use Facebook\WebDriver\Exception\UnrecognizedExceptionException;
use Psr\Log\LoggerInterface;
use Throwable;

final readonly class CaptchaCheckboxFrameDisappearedExceptionHandler implements ExceptionHandlerInterface
{
    public function __construct(
        private LoggerInterface $logger,
    ) {
    }

    public function handleException(WebDriver $webDriver, Context $context, Throwable $exception): bool
    {
        if (!$exception instanceof CaptchaVerificationFailedException) {
            return false;
        }

        $previous = $exception->getPrevious();

        if (
            !$previous instanceof CheckboxFrameNotFoundException &&
            !$previous instanceof ElementNotInteractableException &&
            !$previous instanceof ElementClickInterceptedException &&
            !$previous instanceof NoSuchFrameException &&
            !$previous instanceof UnrecognizedExceptionException
        ) {
            return false;
        }

        if ($previous instanceof UnrecognizedExceptionException && !str_contains($exception->getMessage(), 'target frame detached')) {
            return false;
        }

        $this->logger->warning('Captcha checkbox frame disappeared.', [
            'exception' => $exception,
        ]);

        usleep(200000);

        return true;
    }
}
