<?php

declare(strict_types=1);

namespace Avodel\WebBot\Extension\Network;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebDriver\Driver\WebDriver;

final readonly class NetworkErrorAction implements ActionInterface
{
    /**
     * @throws NetworkErrorException
     */
    public function perform(WebDriver $webDriver, Context $context): never
    {
        $heading = $webDriver->getPage()->find('css', 'span[jsselect="heading"]')?->getText() ?? '';
        $summary = $webDriver->getPage()->find('css', 'p[jsselect="summary"]')?->getText() ?? '';
        $code = $webDriver->getPage()->find('css', 'div[jscontent="errorCode"]')?->getText() ?? '';

        throw new NetworkErrorException($heading, $summary, $code);
    }

    public function isApplicable(WebDriver $webDriver, Context $context): bool
    {
        return $webDriver->getPage()->find('css', 'body.neterror') !== null;
    }
}
