<?php

declare(strict_types=1);

namespace Avodel\WebBot\Extension\WebDriver;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebDriver\Driver\WebDriver;
use Override;

final readonly class FallbackAction implements ActionInterface
{
    /**
     * @throws UnexpectedContextException
     */
    #[Override]
    public function perform(WebDriver $webDriver, Context $context): void
    {
        throw new UnexpectedContextException('Unexpected context.');
    }

    #[Override]
    public function isApplicable(WebDriver $webDriver, Context $context): bool
    {
        return true;
    }
}
