<?php

namespace Avodel\WebBot\Context;

use Avodel\WebBot\State\StateInterface;
use Avodel\WebBot\Worker\Worker;

final class Context
{
    private readonly string $runId;

    private array $states = [];

    public function __construct(
        private readonly Worker $worker,
        private readonly Options $options,
    )
    {
        $this->runId = bin2hex(random_bytes(20));
    }

    /**
     * @template T
     * @phpstan-template T of StateInterface
     *
     * @param class-string<T> $className
     *
     * @return T
     * @phpstan-return T
     */
    public function readState(string $className): StateInterface
    {
        if (isset($this->states[$className])) {
            return $this->states[$className];
        }

        $defaultState = $className::createDefault();
        $this->states[$className] = $defaultState;

        return $defaultState;
    }

    /**
     * @template T
     * @phpstan-template T of StateInterface
     *
     * @param class-string<T> $className
     */
    public function clearState(string $className): void
    {
        unset($this->states[$className]);
    }

    public function getWorker(): Worker
    {
        return $this->worker;
    }

    public function getOptions(): Options
    {
        return $this->options;
    }

    public function getRunId(): string
    {
        return $this->runId;
    }
}
