<?php

namespace Avodel\WebBot\Context;

final class OptionsBuilder
{
    private ?int $ttl = null;
    private int $pauseBetweenUserActionsMinMs = 0;
    private int $pauseBetweenUserActionsMaxMs = 0;

    public function ttl(int $ttl): self
    {
        $this->ttl = $ttl;

        return $this;
    }

    public function pauseBetweenUserActionsMinMs(int $pauseBetweenUserActionsMinMs): self
    {
        $this->pauseBetweenUserActionsMinMs = $pauseBetweenUserActionsMinMs;

        return $this;
    }

    public function pauseBetweenUserActionsMaxMs(int $pauseBetweenUserActionsMaxMs): self
    {
        $this->pauseBetweenUserActionsMaxMs = $pauseBetweenUserActionsMaxMs;

        return $this;
    }

    public function build(): Options
    {
        return new Options(
            $this->ttl,
            $this->pauseBetweenUserActionsMinMs,
            $this->pauseBetweenUserActionsMaxMs,
        );
    }
}
