<?php

namespace Avodel\WebBot\Context;

use Avodel\WebBot\State\StateInterface;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebBot\Worker\Worker;

final class ContextImpl implements Context
{
    private readonly string $runId;

    private array $states = [];

    /**
     * @var array<ActionInterface>
     */
    private array $performedActions = [];

    public function __construct(
        private readonly Worker $worker,
        private readonly Options $options,
    )
    {
        $this->runId = bin2hex(random_bytes(20));
    }

    /**
     * @inheritDoc
     */
    public function readState(string $className): StateInterface
    {
        if (isset($this->states[$className])) {
            return $this->states[$className];
        }

        $defaultState = $className::createDefault();
        $this->states[$className] = $defaultState;

        return $defaultState;
    }

    /**
     * @inheritDoc
     */
    public function clearState(string $className): void
    {
        unset($this->states[$className]);
    }

    public function clearStates(): void
    {
        $this->states = [];
    }

    public function getWorker(): Worker
    {
        return $this->worker;
    }

    public function getOptions(): Options
    {
        return $this->options;
    }

    public function getRunId(): string
    {
        return $this->runId;
    }

    /**
     * @inheritDoc
     */
    public function getPerformedActions(): array
    {
        return $this->performedActions;
    }

    public function addPerformedAction(ActionInterface $action): void
    {
        $this->performedActions[] = $action;
    }
}
