<?php

declare(strict_types=1);

namespace Avodel\WebBot\Extension\Network;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebDriver\Driver\WebDriver;

final readonly class BadGatewayAction implements ActionInterface
{
    /**
     * @throws NetworkErrorException
     */
    public function perform(WebDriver $webDriver, Context $context): never
    {
        throw new NetworkErrorException('Bad Gateway', '', 502);
    }

    public function isApplicable(WebDriver $webDriver, Context $context): bool
    {
        return str_contains((string) $webDriver->getPage()->getHtml(), '<title>502 Bad Gateway</title>');
    }
}
