<?php

namespace Avodel\WebBot\Context;

use Avodel\WebBot\State\StateInterface;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebBot\Worker\Worker;

interface Context
{
    /**
     * @template T
     * @phpstan-template T of StateInterface
     *
     * @param class-string<T> $className
     *
     * @return T
     * @phpstan-return T
     */
    public function readState(string $className): StateInterface;

    /**
     * @template T
     * @phpstan-template T of StateInterface
     *
     * @param class-string<T> $className
     */
    public function clearState(string $className): void;

    public function clearStates(): void;

    public function getWorker(): Worker;

    public function getOptions(): Options;

    public function getRunId(): string;

    /**
     * @return array<ActionInterface>
     */
    public function getPerformedActions(): array;
}
