<?php

namespace Avodel\WebBot\Context;

final readonly class Options
{
    public function __construct(
        private ?int $ttl = null,
        private int $pauseBetweenUserActionsMinMs = 0,
        private int $pauseBetweenUserActionsMaxMs = 0,
    )
    {
    }

    public static function builder(): OptionsBuilder
    {
        return new OptionsBuilder();
    }

    public function getTtl(): ?int
    {
        return $this->ttl;
    }

    public function getPauseBetweenUserActionsMinMs(): int
    {
        return $this->pauseBetweenUserActionsMinMs;
    }

    public function getPauseBetweenUserActionsMaxMs(): int
    {
        return $this->pauseBetweenUserActionsMaxMs;
    }
}
