<?php

namespace Avodel\WebBot\DependencyInjection;

use Avodel\WebBot\Worker\Worker;
use Avodel\WebBot\Worker\WorkersRegistry;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;

final readonly class WebBotProfilesCompilerPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $workersRegistry = $container->getDefinition(WorkersRegistry::class);

        $profilesKey = 'avodel.web_bot.profiles';
        $profiles = $container->getParameter($profilesKey);

        foreach ($profiles as $profile) {
            $actions = [];
            $exceptionHandlers = [];

            $actionsKey = 'avodel.web_bot.profile.' . $profile . '.actions';

            foreach ($container->getParameter($actionsKey) as $action) {
                $actions[] = $container->getDefinition($action);
            }

            $exceptionHandlersKey = 'avodel.web_bot.profile.' . $profile . '.exception_handlers';

            foreach ($container->getParameter($exceptionHandlersKey) as $exceptionHandler) {
                $exceptionHandlers[] = $container->getDefinition($exceptionHandler);
            }

            $worker = new Definition(Worker::class, [
                '$actions' => $actions,
                '$exceptionHandlers' => $exceptionHandlers,
            ]);

            $worker->setAutowired(true);
            $workersRegistry->addMethodCall('add', [$profile, $worker]);

            $container->getParameterBag()->remove($exceptionHandlersKey);
            $container->getParameterBag()->remove($actionsKey);
        }

        $container->getParameterBag()->remove($profilesKey);
    }
}
