<?php

namespace Avodel\WebBot\Extension\Captcha;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebDriver\Driver\WebDriver;
use Psr\Log\LoggerInterface;

final readonly class CaptchaVerifierAction implements ActionInterface
{
    public function __construct(
        private LoggerInterface $logger,
    )
    {
    }

    public function perform(WebDriver $webDriver, Context $context): void
    {
        $this->logger->debug('Starting captcha verification process.');
        $webDriver->getCaptchaVerifier()->verify();
        $this->logger->debug('Verification processed.');
    }

    public function isApplicable(WebDriver $webDriver, Context $context): bool
    {
        return $webDriver->getCaptchaVerifier()->isVerificationRequired();
    }
}
