<?php

declare(strict_types=1);

namespace Avodel\WebBot\Extension\Frame;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ExceptionHandlerInterface;
use Avodel\WebDriver\Components\Frames\SwitchToFrameException;
use Avodel\WebDriver\Driver\WebDriver;
use Psr\Log\LoggerInterface;
use Throwable;

final readonly class FrameNotFoundOrNotSwitchableExceptionHandler implements ExceptionHandlerInterface
{
    public function __construct(
        private LoggerInterface $logger,
    ) {
    }

    public function handleException(WebDriver $webDriver, Context $context, Throwable $exception): bool
    {
        if (!$exception instanceof SwitchToFrameException) {
            return false;
        }

        $this->logger->warning('Frame not found or not switchable.', [
            'exception' => $exception,
        ]);

        usleep(200000);

        return true;
    }
}
