<?php

declare(strict_types=1);

namespace Avodel\WebBot\Extension\Network;

use Exception;

final class NetworkErrorException extends Exception
{
    public function __construct(
        private readonly string $heading,
        private readonly string $summary,
        private readonly int $statusCode,
    )
    {
        parent::__construct('Network error. Heading: ' . $heading . '. Summary: ' . $summary . '. Code: ' . $statusCode);
    }

    public function getHeading(): string
    {
        return $this->heading;
    }

    public function getSummary(): string
    {
        return $this->summary;
    }

    public function getStatusCode(): int
    {
        return $this->statusCode;
    }
}
