<?php

namespace Avodel\WebBot\Extension\WebDriver;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebDriver\Driver\WebDriver;

final readonly class StartWebDriverAction implements ActionInterface
{
    public function perform(WebDriver $webDriver, Context $context): void
    {
        $webDriver->start();
    }

    public function isApplicable(WebDriver $webDriver, Context $context): bool
    {
        return !$webDriver->isStarted();
    }
}
