(function() {
    Object.defineProperty(navigator, 'platform', {
        get: function() { return 'Win32'; }
    });

    Object.defineProperty(navigator, 'webdriver', {
        get: function() { return false; }
    });

    Object.defineProperty(navigator, 'languages', {
        get: function() { return ['en-US', 'en', 'ru', 'uk']; }
    });

    Object.defineProperty(screen, 'width', {
        get: function() { return 1920; }
    });

    Object.defineProperty(screen, 'height', {
        get: function() { return 1080; }
    });

    Object.defineProperty(screen, 'availWidth', {
        get: function() { return 1920; }
    });

    Object.defineProperty(screen, 'availHeight', {
        get: function() { return 1040; }
    });

    Object.defineProperty(navigator, 'deviceMemory', {
        get: function() { return 8; }
    });

    Object.defineProperty(navigator, 'hardwareConcurrency', {
        get: function() { return 4; }
    });

    window.Notification = {
        permission: 'default',
        requestPermission: function() {
            return Promise.resolve('granted');
        }
    };

    Object.defineProperty(navigator, 'plugins', {
        get: function() {
            return {
                length: 2,
                0: { name: 'Chrome PDF Plugin', filename: 'internal-pdf-viewer', description: 'Portable Document Format' },
                1: { name: 'Chrome PDF Viewer', filename: 'mhjfbmdgcfjbbpaeojofohoefgiehjai', description: '' },
            };
        }
    });

    Intl.DateTimeFormat.prototype.resolvedOptions = function() {
        return { timeZone: 'Europe/Warsaw' };
    };

    const getParameter = WebGLRenderingContext.prototype.getParameter;

    WebGLRenderingContext.prototype.getParameter = function(parameter) {
        if (parameter === 37445) { // UNMASKED_VENDOR_WEBGL
            return 'Intel Inc.';
        }
        if (parameter === 37446) { // UNMASKED_RENDERER_WEBGL
            return 'Intel Iris OpenGL Engine';
        }
        return getParameter(parameter);
    };
})();
