# Web Driver
* Useful chrome extensions are available out of the box
* Captcha verifiers are available out of the box
* Uses the latest Chrome version
* Uses mouse over and keyboard actions to interact with the browser
* Uses Mink interface to interact with the browser

```yaml
version: '3'

services:
  test-runner:
    image: registry.gitlab.com/mypie/docker-images/frankenphp8.3-test-runner
    volumes:
      - ./:/app

  browser:
    image: selenium/standalone-chromium:latest
    shm_size: 2gb
```

## Configuration
```yaml
avodel_web_driver:
    host: http://browser:4444/wd/hub
    user_agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36
    components:
        debug:
            dump_dir: /app/screenshots
        captcha_verifier:
            solvers:
                cloudflare_turnstile: App\Context\Login\Captcha\CloudflareTurnstileTokenSolver
        ajax: ~
```

## Using
```php
class Service
{
    public function __construct(
        private readonly WebDriver $webDriver,
    ) {
    }

    public function execute(): void
    {
        $session = $this->webDriver->getSession();
        $session->visit('https://www.vfsglobal.com/');
    }
}
```
