<?php

namespace Avodel\WebDriver;

use Avodel\ProxyHandler\ProxyHandlerInterface;
use Behat\Mink\Driver\DriverInterface;
use Behat\Mink\Session;

final readonly class WebDriver
{
    private Session $session;

    public function __construct(
        DriverInterface $driver,
    )
    {
        $this->session = new Session($driver);
    }

    public function __destruct()
    {
        if ($this->session->isStarted()) {
            $this->session->stop();
        }
    }

    public function getSession(): Session
    {
        return $this->session;
    }
}
