<?php

namespace Avodel\WebDriver\Components\CaptchaVerifier\Verifier;

use Avodel\WebDriver\Components\CaptchaVerifier\Exception\CaptchaVerificationFailedException;
use Avodel\WebDriver\Components\CaptchaVerifier\Solver\CloudflareTurnstileTokenSolverInterface;
use Avodel\WebDriver\Components\CaptchaVerifier\Solver\HCaptchaSolverInterface;
use Avodel\WebDriver\Components\Ajax\AjaxUtil;
use Avodel\WebDriver\Components\Frames\Frame;
use Avodel\WebDriver\Components\Frames\FramesHelper;
use Behat\Mink\Session;
use Exception;
use Webmozart\Assert\Assert;

final readonly class CloudflareTurnstileVerifier implements CaptchaVerifierInterface
{
    public function __construct(
        private CloudflareTurnstileTokenSolverInterface $cloudflareTurnstileSolver,
    )
    {
    }

    public function verify(Session $session): void
    {
        $siteKey = $session->evaluateScript('window.turnstileSiteKey');
        $userAgent = $session->evaluateScript('window.navigator.userAgent');
        $token = $this->cloudflareTurnstileSolver->getSolution($session->getCurrentUrl(), $siteKey, $userAgent);

        $verificationJs = <<<JS
window.postMessage({
    type: "invokeTurnstileCallback",
    params: {publicKey: window.turnstileSiteKey, token: '$token'}
}, location.origin)
JS;

        $session->executeScript($verificationJs);

        Assert::true($session->evaluateScript('window.turnstileSolved'), 'Captcha was not solved.');
    }

    public function isVerificationRequired(Session $session): bool
    {
        return $session->evaluateScript('window.turnstileSiteKey !== undefined && window.turnstileSolved === false');
    }
}
