<?php

namespace Avodel\WebDriver\Components\CaptchaVerifier\Verifier;

use Avodel\WebDriver\Components\Frames\Frame;
use Avodel\WebDriver\Components\Frames\FramesHelper;
use Behat\Mink\Session;
use RuntimeException;

final readonly class RecaptchaV2EnterpriseCaptchaVerifier implements CaptchaVerifierInterface
{
    public function __construct(
        private FramesHelper $framesHelper,
    )
    {
    }

    public function verify(Session $session): void
    {
        throw new RuntimeException('Recaptcha V2 Enterprise prover is not implemented yet.');
    }

    public function isVerificationRequired(Session $session): bool
    {
        [$bFrame, $anchorFrame] = $this->getRecaptchaFrames($session);

        return $bFrame && $anchorFrame;
    }

    /**
     * @return array<Frame|null>
     */
    private function getRecaptchaFrames(Session $session): array
    {
        $allFrames = $this->framesHelper->getFrames($session);
        $bFrame = null;
        $anchorFrame = null;

        foreach ($allFrames as $frame) {
            if (str_starts_with($frame->getSrc(), 'https://www.google.com/recaptcha/enterprise/anchor')) {
                $anchorFrame = $frame;
                continue;
            }

            if (str_starts_with($frame->getSrc(), 'https://www.google.com/recaptcha/enterprise/bframe')) {
                $bFrame = $frame;
            }
        }

        return [$bFrame, $anchorFrame];
    }
}
