(() => {
    "use strict";
    (() => {
        window.addEventListener("message", ( messageEvent => {
            if (typeof  messageEvent.data !== "string") {
                return;
            }

            let eventData;

            try {
                eventData = JSON.parse( messageEvent.data);
            } catch (error) {
                return;
            }

            if (eventData.source !== 'hcaptcha') {
                return;
            }

            if (eventData.label === 'checkbox-loaded') {
                window.hCaptchaSolved = false;
            }

            if (eventData.label === 'challenge-closed') {
                window.hCaptchaSolved = true;
            }
        }));
    })()
})();
