<?php

namespace Avodel\WebDriver;

use Avodel\WebDriver\Driver\MinkPhpWebDriver;
use Behat\Mink\Session;
use Facebook\WebDriver\Remote\WebDriverCapabilityType;

final readonly class WebDriver
{
    private Session $session;

    public function __construct(
        private MinkPhpWebDriver $driver,
    )
    {
        $this->session = new Session($driver);
    }

    public function __destruct()
    {
        if ($this->session->isStarted()) {
            $this->session->stop();
        }
    }

    public function getSession(): Session
    {
        return $this->session;
    }

    public function getHttpProxy(): ?string
    {
        $httpProxy = $this->driver->getDesiredCapabilities()?->getCapability(WebDriverCapabilityType::PROXY)['httpProxy'] ?? null;

        if (!$httpProxy) {
            return null;
        }

        return 'http://' . $httpProxy;
    }
}
