<?php

namespace Avodel\WebDriver\Util;

use Avodel\WebDriver\Driver\DevToolsDriver;
use Facebook\WebDriver\Chrome\ChromeDevToolsDriver;
use Facebook\WebDriver\Remote\RemoteWebDriver;

final readonly class UserAgentOverrider
{
    public function override(RemoteWebDriver $webDriver, string $userAgent): void
    {
        $driver = new DevToolsDriver(new ChromeDevToolsDriver($webDriver));
        $driver->setUserAgentOverride($userAgent);
    }
}
