<?php

namespace Avodel\WebDriver\Components\CaptchaVerifier\Verifier;

use Behat\Mink\Session;

final readonly class CaptchaVerifier implements CaptchaVerifierInterface
{
    public function __construct(
        /**
         * @var array<CaptchaVerifierInterface>
         */
        private array $captchaVerifiers,
    )
    {
    }

    public function verify(Session $session): void
    {
        foreach ($this->captchaVerifiers as $captchaVerifier) {
            if ($captchaVerifier->isVerificationRequired($session)) {
                $captchaVerifier->verify($session);
                return;
            }
        }
    }

    public function isVerificationRequired(Session $session): bool
    {
        foreach ($this->captchaVerifiers as $captchaVerifier) {
            if ($captchaVerifier->isVerificationRequired($session)) {
                return true;
            }
        }

        return false;
    }
}
