<?php

namespace Avodel\WebDriver\Extension;

use Facebook\WebDriver\Chrome\ChromeDevToolsDriver;
use Facebook\WebDriver\Remote\RemoteWebDriver;

final readonly class NavigatorWebDriverFlagWebDriverExtension implements WebDriverExtensionInterface
{
    public function apply(RemoteWebDriver $webDriver): void
    {
        $devTools = new ChromeDevToolsDriver($webDriver);
        $devTools->execute('Page.addScriptToEvaluateOnNewDocument', [
            'source' => file_get_contents(__DIR__ . '/../Resources/js/navigator.webdriver.js'),
        ]);
    }
}
