<?php

namespace Avodel\WebDriver\Extension;

use Avodel\WebDriver\Util\UserAgentOverrider;
use Facebook\WebDriver\Remote\RemoteWebDriver;

final readonly class UserAgentWebDriverExtension implements WebDriverExtensionInterface
{
    public function __construct(
        private UserAgentOverrider $userAgentOverrider,
        private string $userAgent,
    )
    {
    }

    public function apply(RemoteWebDriver $webDriver): void
    {
        $this->userAgentOverrider->override($webDriver, $this->userAgent);
    }
}
