<?php

namespace Avodel\WebDriver\Components\CaptchaVerifier\Verifier;

use Avodel\WebDriver\Components\CaptchaVerifier\Exception\CaptchaVerificationFailedException;
use Avodel\WebDriver\WebDriver;

final readonly class CaptchaVerifier
{
    public function __construct(
        private WebDriver $webDriver,
        /**
         * @var array<CaptchaVerifierInterface>
         */
        private array $captchaVerifiers,
    )
    {
    }

    /**
     * Verifies the not verified captcha on the page.
     *
     * @throws CaptchaVerificationFailedException
     */
    public function verify(): void
    {
        foreach ($this->captchaVerifiers as $captchaVerifier) {
            if ($captchaVerifier->isVerificationRequired($this->webDriver)) {
                $captchaVerifier->verify($this->webDriver);
                return;
            }
        }
    }

    /**
     * Checks if any captcha is not verified on the page.
     */
    public function isVerificationRequired(): bool
    {
        foreach ($this->captchaVerifiers as $captchaVerifier) {
            if ($captchaVerifier->isVerificationRequired($this->webDriver)) {
                return true;
            }
        }

        return false;
    }
}
