<?php

namespace Avodel\WebDriver\DependencyInjection;

use Avodel\WebDriver\Components\CaptchaVerifier\Solver\FallbackCloudflareTurnstileTokenSolver;
use Avodel\WebDriver\Components\CaptchaVerifier\Solver\FallbackHCaptchaSolver;
use Avodel\WebDriver\Components\CaptchaVerifier\Solver\FallbackRecaptchaV2Solver;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('avodel_web_driver');

        $treeBuilder->getRootNode()
            ->children()
                ->scalarNode('host')->isRequired()->end()
                ->scalarNode('proxy')->defaultNull()->end()
                ->scalarNode('user_agent')->isRequired()->end()
                ->arrayNode('components')
                    ->children()
                        ->arrayNode('debug')
                            ->children()
                                ->scalarNode('dump_dir')->defaultValue('/app/.debug')->end()
                            ->end()
                        ->end()
                        ->arrayNode('captcha_verifier')
                            ->children()
                                ->arrayNode('solvers')
                                    ->children()
                                        ->scalarNode('hcaptcha')->defaultValue(FallbackHCaptchaSolver::class)->end()
                                        ->scalarNode('recaptcha_v2')->defaultValue(FallbackRecaptchaV2Solver::class)->end()
                                        ->scalarNode('cloudflare_turnstile')->defaultValue(FallbackCloudflareTurnstileTokenSolver::class)->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('ajax')
                            ->children()
                                ->integerNode('max_waiting_time_ms')->defaultValue(80000)->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
