<?php

namespace Avodel\WebDriver\Components\Debug;

use Avodel\WebDriver\Components\Ajax\AjaxHandler;
use Avodel\WebDriver\Components\Frames\FramesHandler;
use Avodel\WebDriver\Driver\MinkPhpWebDriver;
use Psr\Log\LoggerInterface;

final class Debugger
{
    private DebugDumpFilesPreparer $debugDumpFilesPreparer;

    public function __construct(
        private readonly DebugDumperInterface $debugDumper,
        private readonly MinkPhpWebDriver $driver,
        private readonly AjaxHandler $ajaxHandler,
        private readonly FramesHandler $framesHandler,
        private readonly LoggerInterface $logger,
    )
    {
        $this->debugDumpFilesPreparer = new DebugDumpFilesPreparer(
            $this->driver,
            $this->framesHandler,
            $this->ajaxHandler
        );
    }

    /**
     * Dumps the page state including the content, frames, ajax responses and screenshots to configured storage.
     */
    public function dump(): array
    {
        if (!$this->driver->isStarted()) {
            return [
                'isSessionStarted' => false,
            ];
        }

        $dumpName = 'dump_' . ((int) round(microtime(true) * 1000));

        try {
            $dumpPath = $this->debugDumper->save($this->debugDumpFilesPreparer, $dumpName);
        } catch (\Throwable $e) {
            $this->logger->warning('Unable to save dump.', ['exception' => $e]);
        }

        return [
            'url' => $this->driver->getCurrentUrl(),
            'dump' => $dumpPath ?? '-',
        ];
    }
}
