(function () {
    window.hCaptchaSolved = false;
    window.checkboxTickPerformed = false;

    window.addEventListener("message", (messageEvent => {
        if (typeof messageEvent.data !== "string") {
            return;
        }

        let eventData;

        try {
            eventData = JSON.parse(messageEvent.data);
        } catch (error) {
            return;
        }

        if (eventData.source !== 'hcaptcha') {
            return;
        }

        if (eventData.label === 'site-setup') {
            window.hCaptchaSolved = false;
        }

        if (eventData.label === 'checkbox-tick') {
            window.hCaptchaSolved = true;
            window.checkboxTickPerformed = true;
        }

        if (eventData.label === 'checkbox-reset') {
            window.hCaptchaSolved = false;
        }
    }));
})();
