<?php

declare(strict_types=1);

namespace Avodel\WebDriver\Components\Debug;

readonly class LocalDebugDumper implements DebugDumperInterface
{
    private string $basePath;

    public function __construct(
        string $basePath
    ) {
        $this->basePath = rtrim($basePath, '/');
    }

    public function save(DebugDumpFilesPreparer $debugDumpFilesPreparer, string $dumpName): string
    {
        $dumpPath = $this->basePath . '/' . $dumpName;

        $debugDumpFilesPreparer->prepareDump($dumpPath);

        return $dumpPath;
    }
}