<?php

namespace Avodel\WebDriver\Extension;

use Facebook\WebDriver\Chrome\ChromeDevToolsDriver;
use Facebook\WebDriver\Remote\RemoteWebDriver;

final readonly class StealthWebDriverExtension implements WebDriverExtensionInterface
{
    public function apply(RemoteWebDriver $webDriver): void
    {
        $devTools = new ChromeDevToolsDriver($webDriver);
        $this->addScriptToEvaluateOnNewDocument($devTools, 'hairline.fix.js');
        $this->addScriptToEvaluateOnNewDocument($devTools, 'navigator.platform.js');
        $this->addScriptToEvaluateOnNewDocument($devTools, 'navigator.languages.js');
        $this->addScriptToEvaluateOnNewDocument($devTools, 'navigator.vendor.js');
        $this->addScriptToEvaluateOnNewDocument($devTools, 'navigator.webdriver.js');
    }


    private function addScriptToEvaluateOnNewDocument(ChromeDevToolsDriver $devTools, string $source): void
    {
        $devTools->execute('Page.addScriptToEvaluateOnNewDocument', [
            'source' => file_get_contents(__DIR__ . '/../Resources/js/stealth/' . $source),
        ]);
    }
}
